ORCA/M Asm65816 2.1.0

0001 FF2F                       title 'Interrupt Stuff' 
0002 FF2F              **********************************************************************
0003 FF2F              *
0004 FF2F              * Interrupt Record Stuff
0005 FF2F              * Copyright (C) 1988
0006 FF2F              * Apple Computer, Inc.
0007 FF2F              * All Rights Reserved
0008 FF2F              *
0009 FF2F              * This file contains the routines
0010 FF2F              *
0011 FF2F              *      GetInterruptState
0012 FF2F              *      SetInterruptState
0013 FF2F              *      GetIntStateRecSize
0014 FF2F              *
0015 FF2F              *
0016 FF2F              **********************************************************************
0017 FF2F
0018 FF2F                       include 'all.macros' 
0019 FF2F                       include 'mt.equates.asm' 
0020 FF2F                       include '::sys.equs.asm' 
0021 FF2F
0022 FF2F
0023 FF2F              IntStateRecSize equ AVal-irq_A 
0024 FF2F
0025 FF2F              ****************************************************************
0026 FF2F              *
0027 FF2F              GetInterruptState PROC EXPORT 
0028 FF2F              *
0029 FF2F              * This copies the first BytesDesired bytes of the system interrupt
0030 FF2F              * variables into the specified InterruptStateRecord.
0031 FF2F              *
0032 FF2F              *
0033 FF2F              * Inputs:
0034 FF2F              *                   StateRecPtr
0035 FF2F              *                   BytesDesired
0036 FF2F              *
0037 FF2F              * Outputs:
0038 FF2F              *                   none
0039 FF2F              *
0040 FF2F              * External Refs:
0041 FF2F                       import EndCall6 
0042 FF2F              *
0043 FF2F              * Entry Points:
0044 FF2F              *                   none
0045 FF2F              *
0046 FF2F                       longa on                       ; mode
0047 FF2F                       longi on
0048 FF2F              *
0049 FF2F              ****************************************************************
0050 FF2F
0051 FF2F                             DefineStack  
0052 FF2F              OrigD          word  
0053 FF2F              RTL1           block 3  
0054 FF2F              RTL2           block 3  
0055 FF2F              BytesDesired   word  
0056 FF2F              StateRecPtr    LONG  
0057 FF2F
0058 FF2F 0B                    phd   
0059 FF30 3B                    tsc   
0060 FF31 5B                    tcd   
0061 FF32
0062 FF32 8B                    phb   
0063 FF33 F4 E1 E1              pea   #$e1e1
0064 FF36 AB                    plb   
0065 FF37 AB                    plb   
0066 FF38
0067 FF38 A4 09                 ldy   BytesDesired
0068 FF3A C0 18 00              cpy   #IntStateRecSize
0069 FF3D 90 03                 bcc   @1
0070 FF3F A0 18 00              ldy   #IntStateRecSize
0071 FF42 88           @1       dey   
0072 FF43 E2 20                 sep   #$20
0073 FF45                       longa off
0074 FF45
0075 FF45
0076 FF45 B9 08 01     Loop     lda   |irq_A,y
0077 FF48 97 0B                 sta   [StateRecPtr],y
0078 FF4A 88                    dey   
0079 FF4B 10 F8                 bpl   Loop
0080 FF4D
0081 FF4D
0082 FF4D C2 20                 rep   #$20
0083 FF4F                       longa on
0084 FF4F
0085 FF4F AB                    plb   
0086 FF50
0087 FF50 5C 24 FC FE           jml   EndCall6
0088 FF54
0089 FF54                       ENDP 
0090 FF54
0091 FF54
0092 FF54
0093 FF54              ****************************************************************
0094 FF54              *
0095 FF54              SetInterruptState PROC EXPORT 
0096 FF54              *
0097 FF54              * This copies the first BytesDesired bytes from the specified 
0098 FF54              * IntStateRecord into the interrupt state variables in bank $E1.
0099 FF54              *
0100 FF54              *
0101 FF54              * Inputs:
0102 FF54              *                   StateRecPtr
0103 FF54              *                   BytesDesired
0104 FF54              *
0105 FF54              * Outputs:
0106 FF54              *                   none
0107 FF54              *
0108 FF54              * External Refs:
0109 FF54                       import EndCall6 
0110 FF54              *
0111 FF54              * Entry Points:
0112 FF54              *                   none
0113 FF54              *
0114 FF54                       longa on                       ; mode
0115 FF54                       longi on
0116 FF54              *
0117 FF54              ****************************************************************
0118 FF54
0119 FF54                             DefineStack  
0120 FF54              OrigD          word  
0121 FF54              RTL1           block 3  
0122 FF54              RTL2           block 3  
0123 FF54              BytesDesired   word  
0124 FF54              StateRecPtr    LONG  
0125 FF54
0126 FF54 0B                    phd   
0127 FF55 3B                    tsc   
0128 FF56 5B                    tcd   
0129 FF57
0130 FF57 8B                    phb   
0131 FF58 F4 E1 E1              pea   #$e1e1
0132 FF5B AB                    plb   
0133 FF5C AB                    plb   
0134 FF5D
0135 FF5D A4 09                 ldy   BytesDesired
0136 FF5F C0 18 00              cpy   #IntStateRecSize
0137 FF62 90 03                 bcc   @1
0138 FF64 A0 18 00              ldy   #IntStateRecSize
0139 FF67 88           @1       dey   
0140 FF68 E2 20                 sep   #$20
0141 FF6A                       longa off
0142 FF6A
0143 FF6A
0144 FF6A              Loop      
0145 FF6A B7 0B                 lda   [StateRecPtr],y
0146 FF6C 99 08 01              sta   |irq_a,y
0147 FF6F 88                    dey   
0148 FF70 10 F8                 bpl   Loop
0149 FF72
0150 FF72
0151 FF72 C2 20                 rep   #$20
0152 FF74                       longa on
0153 FF74
0154 FF74 AB                    plb   
0155 FF75
0156 FF75 5C 24 FC FE           jml   EndCall6
0157 FF79
0158 FF79                       ENDP 
0159 FF79
0160 FF79
0161 FF79
0162 FF79              ****************************************************************
0163 FF79              *
0164 FF79              GetIntStateRecSize PROC EXPORT 
0165 FF79              *
0166 FF79              * This returns the size of the interrupt state record.
0167 FF79              *
0168 FF79              *
0169 FF79              * Inputs:
0170 FF79              *                   space for integer
0171 FF79              *
0172 FF79              * Outputs:
0173 FF79              *                   SizeofIntStateRecord
0174 FF79              *
0175 FF79              * External Refs:
0176 FF79                       import oEndCall0 
0177 FF79              *
0178 FF79              * Entry Points:
0179 FF79              *                   none
0180 FF79              *
0181 FF79                       longa on                       ; mode
0182 FF79                       longi on
0183 FF79              *
0184 FF79              ****************************************************************
0185 FF79
0186 FF79                       DefineStack 
0187 FF79              RTL1     block 3 
0188 FF79              RTL2     block 3 
0189 FF79              Size     word 
0190 FF79
0191 FF79
0192 FF79 A9 18 00              lda   #IntStateRecSize
0193 FF7C 83 07                 sta   Size,s
0194 FF7E
0195 FF7E 5C DF FB FE           jml   oEndCall0
0196 FF82
0197 FF82                       ENDP 
0198 FF82
0199 FF82
0200 FF82                       END   
